using System;
using Server;
using Server.Items;
using System.Collections;
using System.Collections.Generic;
using Server.Mobiles;

namespace Server.Items
{
	[FlipableAttribute( 0x27A9, 0x27F4 )]
	public class Daisho2 : BaseSword
	{
		public override int ArtifactRarity{ get{ return 100; } }
		
		public override WeaponAbility PrimaryAbility{ get{ return WeaponAbility.Feint; } }
		public override WeaponAbility SecondaryAbility{ get{ return WeaponAbility.DoubleStrike; } }

		public override int AosStrengthReq{ get{ return 40; } }
		public override int AosMinDamage{ get{ return 17; } }
		public override int AosMaxDamage{ get{ return 22; } }
		public override int AosSpeed{ get{ return 40; } }

		public override int OldStrengthReq{ get{ return 40; } }
		public override int OldMinDamage{ get{ return 13; } }
		public override int OldMaxDamage{ get{ return 15; } }
		public override int OldSpeed{ get{ return 40; } }

		public override int DefHitSound{ get{ return 0x23B; } }
		public override int DefMissSound{ get{ return 0x23A; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		[Constructable]
		public Daisho2() : base( 0x27A9 )
		{
			Weight = 8.0;
			Layer = Layer.TwoHanded;
			Name = "Daisho";
			Hue = 1161;
			LootType = LootType.Blessed;
			Attributes.AttackChance = 35;
			Attributes.WeaponDamage = 30;
			Attributes.BonusDex = 10;
			Attributes.BonusHits = 20;
			Attributes.BonusStr = 10;
			Attributes.Luck = 150;
			Attributes.RegenHits = 4;
			Attributes.RegenStam = 4;
			Attributes.WeaponSpeed = 25;
         Attributes.SpellChanneling = 1;
			WeaponAttributes.HitLeechHits = 30;
			WeaponAttributes.HitLeechStam = 35;
			WeaponAttributes.HitLightning = 35;
			WeaponAttributes.HitLowerAttack = 35;
			WeaponAttributes.HitLowerDefend = 25;
			WeaponAttributes.HitMagicArrow = 25;
			WeaponAttributes.SelfRepair = 5;
         WeaponAttributes.BattleLust = 1;
			
			SkillBonuses.SetValues( 0, SkillName.Bushido, 20.0 );
			SkillBonuses.SetValues( 1, SkillName.Tactics, 20.0 );
		}

		public Daisho2( Serial serial ) : base( serial )
		{
		}
		
		public override void GetDamageTypes(Mobile wielder, out int phys, out int fire, out int cold, out int pois, out int nrgy)
		{
			cold = nrgy = 50;
			fire = phys = pois = 0;
		}
		
		public override void OnHit(Mobile attacker, Mobile defender, double damageBonus)
		{
			if ( attacker.Player && !defender.Player && 0.1 > Utility.RandomDouble() )
				Aura( attacker );
			
			base.OnHit( attacker, defender, damageBonus );
		}
		
		private void Aura( Mobile attacker )
		{

			if ( attacker == null )
				return;
			
			if ( attacker.Map == null)
				return;

			Point3D p = attacker.Location;
			attacker.PlaySound(0x208);
			Map map = attacker.Map;

			for (int i = -3; i <= 3; ++i)
			{
				for (int j = -3; j <= 3; ++j)
				{
					if (Utility.RandomDouble() < 0.8)
					{
						Point3D loc = new Point3D(p.X + i, p.Y + j, p.Z);
						bool canFit = Spells.SpellHelper.AdjustField(ref loc, map, 12, false);
						
						if ( !canFit )
							continue;
						
						SelfDeletingItem fire = new SelfDeletingItem( 0x3709, "flame", 2 );
						fire.Visible = false;
						fire.MoveToWorld( loc, map );
						
						if ( !attacker.InLOS( fire ) )
						{
							if ( fire != null )
								fire.Delete();
							
							continue;
						}
						else
							fire.Visible = true;
						
						ArrayList targets = new ArrayList();

						foreach (Mobile m in fire.GetMobilesInRange(0))
						{
							if ( m == null || m.Deleted || m == attacker )
								continue;

							if (m is BaseCreature && !(((BaseCreature)m).Controlled || ((BaseCreature)m).Summoned))
							{
								if ( !m.IsDeadBondedPet && m.Alive && !m.Blessed )
									targets.Add(m);
							}
						}

						for (int c = 0; c < targets.Count; ++c)
						{
							Mobile m = (Mobile)targets[c];
							
							if ( m == null || m.Deleted )
								continue;

							m.RevealingAction();
							//attacker.DoHarmful(m);
							Effects.PlaySound( m.Location, map, 0x208 );
							
							double damage = GetAosDamage(attacker, 40, 2, 10);
							Spells.SpellHelper.Damage(TimeSpan.FromSeconds(1.0), m, attacker, damage, 0, 100, 0, 0, 0);

							//AOS.Damage( m, attacker, Utility.Random( 150, 200 ), 0, 100, 0, 0, 0 );
						}
					}
				}
			}
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#33FF66>Armageddon spell<basefont color=White>" );
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 1 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
			
			if ( version == 0 )
			   WeaponAttributes.BattleLust = 1;
		}
	}
}
